%------------------------------------------------------------------------------
% File     : PRO029^16 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Processes
% Problem  : Phone user and company (requirement 1)
% Version  : [BP13] axioms.
% English  : Phone user U and phone company C have following relationship:
%            + U does not pay a call before he has dialled it.
%            + Both U nd C are able to prove when U is being charged.
%            + U is able to prove that C can prove that U has made a call,
%            + C is able to prove that U can prove that U has paid his call,
%            + U is able to prove that C cannot prove that U has made a call,
%            + C is able to prove that U cannot prove that he has paid his
%              call, whenever these facts are true.
%            Then the following requirement is true: From U's point of view,
%            C should charge U only if he has made a call that is not yet paid.

% Refs     : [HA97]  Huima & Aura (1997), Using Multimodal Logic to Express
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : MML011+1 [QMLTP]
%          : MML011^1.016_s4_cumulative_rigid.p [QMLTP/5_THF]

% Status   : Theorem 
% Rating   : 0.22 v9.1.0, 0.25 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0
% Syntax   : Number of formulae    :   36 (  10 unt;  17 typ;   8 def)
%            Number of atoms       :   85 (   8 equ;   0 cnn)
%            Maximal formula atoms :   17 (   4 avg)
%            Number of connectives :  118 (   1   ~;   1   |;   4   &; 107   @)
%                                         (   1 <=>;   4  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   4 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   51 (  51   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   16 (  15 usr;   3 con; 0-3 aty)
%            Number of variables   :   31 (  21   ^;   9   !;   1   ?;  31   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $cumulative,
%            $modalities == $modal_system_S4].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mindex,type,
    mindex: $tType ).

thf(mrel_type,type,
    mrel: mindex > mworld > mworld > $o ).

thf('#c_type',type,
    '#c': mindex ).

thf('#u_type',type,
    '#u': mindex ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: mindex > ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ R @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: mindex > ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [R: mindex,Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ R @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf('mrel_#c_reflexive',axiom,
    ! [W: mworld] : ( mrel @ '#c' @ W @ W ) ).

thf('mrel_#c_transitive',axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ '#c' @ W @ V )
        & ( mrel @ '#c' @ V @ U ) )
     => ( mrel @ '#c' @ W @ U ) ) ).

thf('mrel_#u_reflexive',axiom,
    ! [W: mworld] : ( mrel @ '#u' @ W @ W ) ).

thf('mrel_#u_transitive',axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ '#u' @ W @ V )
        & ( mrel @ '#u' @ V @ U ) )
     => ( mrel @ '#u' @ W @ U ) ) ).

thf(charge_decl,type,
    charge: mworld > $o ).

thf(called_decl,type,
    called: mworld > $o ).

thf(paid_decl,type,
    paid: mworld > $o ).

thf(aciom_paid_charge,axiom,
    mlocal @ ( mimplies @ paid @ called ) ).

thf(axiom_charge_u,axiom,
    mlocal @ ( mimplies @ charge @ ( mand @ ( mbox @ '#u' @ charge ) @ ( mbox @ '#c' @ charge ) ) ) ).

thf(axiom_1,axiom,
    mlocal @ ( mbox @ '#u' @ ( mimplies @ called @ ( mbox @ '#c' @ called ) ) ) ).

thf(axiom_2,axiom,
    mlocal @ ( mbox @ '#c' @ ( mimplies @ paid @ ( mbox @ '#u' @ paid ) ) ) ).

thf(axiom_3,axiom,
    mlocal @ ( mimplies @ ( mnot @ ( mbox @ '#c' @ called ) ) @ ( mbox @ '#u' @ ( mnot @ ( mbox @ '#c' @ called ) ) ) ) ).

thf(axiom_4,axiom,
    mlocal @ ( mimplies @ ( mnot @ ( mbox @ '#u' @ paid ) ) @ ( mbox @ '#c' @ ( mnot @ ( mbox @ '#u' @ paid ) ) ) ) ).

thf(requirement_1,conjecture,
    mlocal @ ( mimplies @ ( mnot @ ( mimplies @ charge @ ( mand @ called @ ( mnot @ paid ) ) ) ) @ ( mbox @ '#u' @ ( mnot @ ( mimplies @ charge @ ( mand @ called @ ( mnot @ paid ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
